<?php
include 'template/koneksi.php';
$now = date('Y-m-d');

// Query untuk mengambil data pengguna berdasarkan username
$sql = "SELECT * FROM tbl_user WHERE username = ?";
$stmt = $conn->prepare($sql);
$stmt->bind_param("s", $username);
$stmt->execute();
$result = $stmt->get_result();

$userData = $result->fetch_assoc();

// Query untuk menghitung jumlah siswa
$query = "SELECT COUNT(*) AS total_siswa FROM tbl_siswa";
$stmt2 = $conn->prepare($query); 
$stmt2->execute();
$result2 = $stmt2->get_result();
$total_siswa = 0;

if ($result2->num_rows > 0) {
    $row = $result2->fetch_assoc();
    $total_siswa = $row['total_siswa'];
}

// Query untuk menghitung jumlah kelas
$query3 = "SELECT COUNT(*) AS total_kelas FROM tbl_kelas";
$stmt3 = $conn->prepare($query3); 
$stmt3->execute();
$result3 = $stmt3->get_result();
$total_kelas = 0;

if ($result3->num_rows > 0) {
    $row = $result3->fetch_assoc();
    $total_kelas = $row['total_kelas'];
}

// Query untuk menghitung jumlah absensi "Hadir"
$query_hadir = "SELECT COUNT(*) AS total_hadir FROM tbl_absensi WHERE status = 'Hadir' AND date_time LIKE '$now%'";
$stmt_hadir = $conn->prepare($query_hadir);
$stmt_hadir->execute();
$result_hadir = $stmt_hadir->get_result();
$total_hadir = $result_hadir->fetch_assoc()['total_hadir'] ?? 0;

// Query untuk menghitung jumlah absensi "Terlambat"
$query_terlambat = "SELECT COUNT(*) AS total_terlambat FROM tbl_absensi WHERE status = 'Terlambat' AND date_time LIKE '$now%'";
$stmt_terlambat = $conn->prepare($query_terlambat);
$stmt_terlambat->execute();
$result_terlambat = $stmt_terlambat->get_result();
$total_terlambat = $result_terlambat->fetch_assoc()['total_terlambat'] ?? 0;

// Hitung total absensi
$total_absensi = $total_hadir + $total_terlambat;

// Hitung persentase
$persentase_hadir = $total_absensi > 0 ? ($total_hadir / $total_absensi) * 100 : 0;
$persentase_terlambat = $total_absensi > 0 ? ($total_terlambat / $total_absensi) * 100 : 0;
// ---------------------------------------------------------------------------------------------------


// hitung presentase absensi berdasarkan menit 
$query = "SELECT 
              DATE_FORMAT(date_time, '%H:%i') AS jam_menit, 
              COUNT(*) AS jumlah_absen 
          FROM tbl_absensi 
          WHERE date_time LIKE '$now%'
          GROUP BY jam_menit 
          ORDER BY jam_menit ASC";

$result = $conn->query($query); 

$data_absensi = [];
$labels = [];
while ($row = $result->fetch_assoc()) {
    $labels[] = $row['jam_menit'];
    $data_absensi[] = (int)$row['jumlah_absen'];
}

// Ubah array ke dalam format JSON
$labels_json = json_encode($labels);
$data_absensi_json = json_encode($data_absensi);

// Tutup statement
$stmt_hadir->close();
$stmt_terlambat->close();

// Query untuk mengambil recent login
$query_recent_login = "
    SELECT l.waktu, u.username, l.device, l.lokasi
    FROM tbl_log l
    JOIN tbl_user u ON l.user_id = u.id
    ORDER BY l.waktu DESC
    LIMIT 5"; // Menampilkan 5 login terbaru
$stmt_recent_login = $conn->prepare($query_recent_login);
$stmt_recent_login->execute();
$result_recent_login = $stmt_recent_login->get_result();

// Menyimpan data login terbaru dalam array
$recent_logins = [];
while ($row = $result_recent_login->fetch_assoc()) {
    $recent_logins[] = $row;
}

// Tutup statement dan koneksi
$stmt->close();
$conn->close();

include 'template/header.php';
include 'template/menu.php';

?>

            
<div class="page-heading">
    <h3>Dashboard Absensi Hari ini</h3>
</div> 
<div class="page-content"> 
    <section class="row">
        <div class="col-12 col-lg-8">
            <div class="row">
                <div class="col-4 col-lg-4">
                    <div class="card">
                        <div class="card-body px-4 py-4-5">
                            <div class="row">
                                <div class="col-md-4 col-lg-12 col-xl-12 col-xxl-5 d-flex justify-content-start ">
                                <div class="stats-icon purple mb-2">
                                    <i class="fas fa-user-graduate"></i>
                                </div>

                                </div>
                                <div class="col-md-8 col-lg-12 col-xl-12 col-xxl-7">
                                    <h6 class="text-muted font-semibold">Siswa</h6>
                                    <h6 class="font-extrabold mb-0"><?php echo $total_siswa; ?></h6>
                                </div>
                            </div> 
                        </div>
                    </div>
                </div>
                <div class="col-4 col-lg-4">
                    <div class="card"> 
                        <div class="card-body px-4 py-4-5">
                            <div class="row">
                                <div class="col-md-4 col-lg-12 col-xl-12 col-xxl-5 d-flex justify-content-start ">
                                    <div class="stats-icon blue mb-2">
                                        <i class="fas fa-chalkboard-teacher"></i>
                                    </div>
                                </div>
                                <div class="col-md-8 col-lg-12 col-xl-12 col-xxl-7">
                                    <h6 class="text-muted font-semibold">Kelas</h6>
                                    <h6 class="font-extrabold mb-0"><?php echo $total_kelas; ?></h6>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-4 col-lg-4">
                    <div class="card">
                        <div class="card-body px-4 py-4-5">
                            <div class="row">
                                <div class="col-md-4 col-lg-12 col-xl-12 col-xxl-5 d-flex justify-content-start ">
                                    <div class="stats-icon red mb-2">
                                        <i class="fas fa-user-tie"></i>
                                    </div>
                                </div>
                                <div class="col-md-8 col-lg-12 col-xl-12 col-xxl-7">
                                    <h6 class="text-muted font-semibold">Admin</h6>
                                    <h6 class="font-extrabold mb-0">2</h6>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="row">
                <div class="col-12">
                    <div class="card">
                        <div class="card-header">
                            <h4>Grafik Absensi by Menit</h4>
                        </div>
                        <div class="card-body">
                            <div id="chart-profile-visit"></div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="row">
                <div class="col-12">
                    
                </div>
            </div>
        </div>
        <div class="col-12 col-lg-4">
            <div class="card">
                <div class="card-body py-4 px-4">
                    <div class="d-flex align-items-center">
                        <div class="avatar avatar-xl">
                            <div class="stats-icon red mb-2">
                                <i class="fas fa-user-tie"></i>
                            </div>
                        </div>
                        <div class="ms-3 name">
                            <h5 class="font-bold"><?php echo htmlspecialchars($userData['username']); ?></h5>
                            <h6 class="text-muted mb-0"><?php echo htmlspecialchars($userData['role_id']); ?></h6>
                        </div>
                    </div>
                </div>
            </div>
            <div class="card">
                <div class="card-header">
                    <h4>Presentase hari ini</h4>
                </div>
                <div class="card-body">
                    <div id="chart-performa-absensi"></div>
                </div>
            </div>
            <div class="card">
                <div class="card-header">
                    <h4>Recent Login</h4>
                </div>
                <div class="card-content pb-3">
                    <!-- start log user login -->
                    <?php if (count($recent_logins) > 0): ?>
                        <?php foreach ($recent_logins as $log): ?>
                            <div class="recent-message d-flex px-4 py-3">
                                <div class="name">
                                    <h5 class="mb-1">@<?php echo htmlspecialchars($log['username']); ?></h5>
                                    <p style="font-size:11px">
                                        <span><i class="fas fa-clock"></i> <?php echo date('Y-m-d H:i:s', strtotime($log['waktu'])); ?> | 
                                            <i class="fas fa-laptop"></i> <?php echo htmlspecialchars($log['device']); ?> | 
                                            <i class="fas fa-map-marker-alt"></i> <?php echo htmlspecialchars($log['lokasi']); ?></span><br>
                                    </p>

                                </div>
                            </div>
                        <?php endforeach; ?>
                    <?php else: ?>
                        <p>No recent logins available.</p>
                    <?php endif; ?>
                    <!-- end log user login -->
                </div>

            </div> 
            
        </div>
    </section>
</div>

<script>
    // Grafik kehadiran berdasarkan menit
    let labelsAbsensi = <?php echo $labels_json; ?>;
    let dataAbsensi = <?php echo $data_absensi_json; ?>;

    var optionsProfileVisit = {
        annotations: {
            position: "back",
        },
        dataLabels: {
            enabled: false,
        },
        chart: {
            type: "bar",
            height: 300,
        },
        fill: {
            opacity: 1,
        },
        plotOptions: {},
        series: [{
            name: 'Jumlah Absen',
            data: dataAbsensi, // Data jumlah absensi (sumbu Y)
        }],
        colors: "#435ebe",
        xaxis: {
            categories: labelsAbsensi, // Data jam:menit (sumbu X)
            title: {
                text: 'Waktu (Jam:Menit)',
            },
        },
        yaxis: {
            title: {
                text: 'Jumlah Siswa',
            },
        },
    }

    // chart presentase hari ini
    let optionsPerformaAbsensi = {
    series: [<?php echo json_encode($persentase_terlambat); ?>, <?php echo json_encode($persentase_hadir); ?>],
    labels: ["Terlambat", "Hadir"],
    colors: ["#435ebe", "#55c6e8"],
    chart: {
        type: "donut",
        width: "100%",
        height: "350px",
    },
    legend: {
        position: "bottom",
    },
    plotOptions: {
        pie: {
        donut: {
            size: "30%",
        },
        },
    },
    }
</script>
<?php
include 'template/footer.php'
?>
