<?php
include 'template/koneksi.php';

// Ambil ID siswa dari parameter URL
$id_siswa = isset($_GET['id']) ? intval($_GET['id']) : 0;

// Jika ID siswa tidak valid, redirect kembali ke halaman siswa.php
if ($id_siswa <= 0) {
    header("Location: siswa.php");
    exit();
}

// Query untuk mengambil data siswa berdasarkan ID
$sql = "SELECT * FROM tbl_siswa WHERE id_siswa = ?";
$stmt = $conn->prepare($sql);
$stmt->bind_param("i", $id_siswa);
$stmt->execute();
$result = $stmt->get_result();
$siswa = $result->fetch_assoc();

// Jika data siswa tidak ditemukan, redirect kembali ke halaman siswa.php
if (!$siswa) {
    header("Location: siswa.php");
    exit();
}

// Tutup statement
$stmt->close();

// Fungsi untuk memotong gambar menjadi ukuran persegi
function cropImageToSquare($sourcePath, $destinationPath, $fileExt)
{
    list($width, $height) = getimagesize($sourcePath);
    $minDimension = min($width, $height);
    $x = ($width - $minDimension) / 2;
    $y = ($height - $minDimension) / 2;

    $image = null;
    switch ($fileExt) {
        case 'jpg':
        case 'jpeg':
            $image = imagecreatefromjpeg($sourcePath);
            break;
        case 'png':
            $image = imagecreatefrompng($sourcePath);
            break;
        case 'gif':
            $image = imagecreatefromgif($sourcePath);
            break;
        default:
            return false; // Format file tidak didukung
    }

    if ($image) {
        $squareImage = imagecrop($image, ['x' => $x, 'y' => $y, 'width' => $minDimension, 'height' => $minDimension]);
        if ($squareImage) {
            switch ($fileExt) {
                case 'jpg':
                case 'jpeg':
                    imagejpeg($squareImage, $destinationPath);
                    break;
                case 'png':
                    imagepng($squareImage, $destinationPath);
                    break;
                case 'gif':
                    imagegif($squareImage, $destinationPath);
                    break;
            }
            imagedestroy($squareImage);
        }
        imagedestroy($image);
        return true;
    }
    return false;
}

// Proses update data siswa jika form disubmit
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $rfid = $_POST['rfid'];
    $nis = $_POST['nis'];
    $nama_siswa = $_POST['nama_siswa'];
    $id_kelas = $_POST['id_kelas'];
    $telepon_siswa = $_POST['telepon_siswa'];
    $nama_wali = $_POST['nama_wali'];
    $telepon_wali = $_POST['telepon_wali'];
    $foto_lama = $_POST['foto_lama'];

    $foto_baru = $_FILES['foto']['name'];
    $foto_tmp = $_FILES['foto']['tmp_name'];

    // Jika ada foto baru, proses upload
    if (!empty($foto_baru)) {
        // Hapus foto lama jika ada
        if (!empty($siswa['foto'])) {
            $foto_lama_path = 'foto/' . $foto_lama;
            if (file_exists($foto_lama_path)) {
                chmod($foto_lama_path, 0777);
                unlink($foto_lama_path); // Hapus foto lama
            }
        }

        $uploadDir = 'foto/'; // Folder penyimpanan file
        $fileTmp = $_FILES['foto']['tmp_name'];
        $fileName = basename($_FILES['foto']['name']);
        $fileExt = strtolower(pathinfo($fileName, PATHINFO_EXTENSION));
        $allowedExt = ['jpg', 'jpeg', 'png', 'gif'];

        // Validasi ekstensi file
        if (in_array($fileExt, $allowedExt)) {
            // Format nama file: "nama-uniqid-rfid.ext"
            $cleanedName = preg_replace("/[^a-zA-Z0-9]/", "", $nama_siswa); // Bersihkan nama_siswa dari karakter tidak valid
            $newFileName = "{$cleanedName}-" . uniqid() . "-{$rfid}.{$fileExt}";
            $uploadPath = $uploadDir . $newFileName;

            // Pindahkan file ke folder tujuan
            if (move_uploaded_file($fileTmp, $uploadPath)) {
                // Crop gambar menjadi persegi
                $croppedPath = $uploadDir . "cropped-" . $newFileName;
                if (cropImageToSquare($uploadPath, $croppedPath, $fileExt)) {
                    // Hapus file asli jika cropping berhasil dan gunakan file yang telah dicrop
                    unlink($uploadPath);
                    $foto_siswa = "cropped-" . $newFileName;
                } else {
                    echo "Gagal memproses cropping gambar.";
                    exit();
                }
            } else {
                echo "Gagal mengunggah file.";
                exit();
            }
        } else {
            echo "Format file tidak didukung. Gunakan file dengan format jpg, jpeg, png, atau gif.";
            exit();
        }
    } else {
        $foto_siswa = $siswa['foto']; // Tetap gunakan foto lama
    }

    // Query untuk mengupdate data siswa
    $sql_update = "UPDATE tbl_siswa SET rfid = ?, nis = ?, nama_siswa = ?, id_kelas = ?, telepon_siswa = ?, nama_wali = ?, telepon_wali = ?, foto_siswa = ? WHERE id_siswa = ?";
    $stmt_update = $conn->prepare($sql_update);
    $stmt_update->bind_param("ssssssssi", $rfid, $nis, $nama_siswa, $id_kelas, $telepon_siswa, $nama_wali, $telepon_wali, $foto_siswa, $id_siswa);

    if ($stmt_update->execute()) {
        // Jika update berhasil, redirect kembali ke halaman siswa.php dengan pesan sukses
        header("Location: siswa.php?status=update_success");
        exit();
    } else {
        $error_message = "Gagal mengupdate data siswa!";
    }

    // Tutup statement update
    $stmt_update->close();
}


include 'template/header.php';
include 'template/menu.php';
?>

<?php if (isset($error_message)) : ?>
    <div class="alert alert-danger alert-dismissible fade show" role="alert">
        <?php echo $error_message; ?>
        <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
    </div>
<?php endif; ?>

<!-- Form Edit Siswa -->
<div class="container mt-5">
    <h2>Edit Siswa</h2>
    <form class="form form-vertical" method="POST" action="edit_siswa.php?id=<?php echo $id_siswa; ?>" enctype="multipart/form-data">
        <div class="form-body">
            <div class="row">
                <div class="col-12">
                    <div class="form-group">
                        <label for="rfid">RFID</label>
                        <input type="text" class="form-control" name="rfid" value="<?php echo htmlspecialchars($siswa['rfid']); ?>" required>
                    </div>
                </div>
                <div class="col-12">
                    <div class="form-group">
                        <label for="nis">NIS</label>
                        <input type="text" class="form-control" name="nis" value="<?php echo htmlspecialchars($siswa['nis']); ?>" required>
                    </div>
                </div>
                <div class="col-12">
                    <div class="form-group">
                        <label for="nama_siswa">Nama Siswa</label>
                        <input type="text" class="form-control" name="nama_siswa" value="<?php echo htmlspecialchars($siswa['nama_siswa']); ?>" required>
                    </div>
                </div>
                <div class="col-12">
                    <div class="form-group">
                        <label for="id_kelas">Kelas</label>
                        <select class="form-select" id="basicSelect" name="id_kelas" required>
                            <option value="">Pilih Kelas</option>
                            <?php
                            // Query untuk mengambil data kelas dari tabel tbl_kelas
                            $sql_kelas = "SELECT id_kelas, nama_kelas FROM tbl_kelas ORDER BY nama_kelas ASC";
                            $result_kelas = $conn->query($sql_kelas);

                            // Loop untuk menampilkan data kelas sebagai opsi dropdown
                            if ($result_kelas->num_rows > 0) {
                                while ($row_kelas = $result_kelas->fetch_assoc()) {
                                    echo '<option value="' . htmlspecialchars($row_kelas['id_kelas']) . '">' . htmlspecialchars($row_kelas['nama_kelas']) . '</option>';
                                }
                            } else {
                                echo '<option value="">Tidak ada data kelas</option>';
                            }
                            ?>
                        </select>
                </div>
                <div class="col-12">
                    <div class="form-group">
                        <label for="telepon_siswa">Telepon Siswa</label>
                        <input type="text" class="form-control" name="telepon_siswa" value="<?php echo htmlspecialchars($siswa['telepon_siswa']); ?>" required>
                    </div>
                </div>
                <div class="col-12">
                    <div class="form-group">
                        <label for="nama_wali">Nama Wali</label>
                        <input type="text" class="form-control" name="nama_wali" value="<?php echo htmlspecialchars($siswa['nama_wali']); ?>" required>
                    </div>
                </div>
                <div class="col-12">
                    <div class="form-group">
                        <label for="telepon_wali">Telepon Wali</label>
                        <input type="text" class="form-control" name="telepon_wali" value="<?php echo htmlspecialchars($siswa['telepon_wali']); ?>" required>
                        <input type="hidden" class="form-control" name="foto_lama" value="<?php echo htmlspecialchars($siswa['foto_siswa']); ?>" required>
                    </div>
                </div>
                <div class="col-12">
                    <div class="form-group">
                        <label for="foto">Foto Siswa</label>
                        <input type="file" class="form-control" name="foto" accept="image/*">
                        <?php if (!empty($siswa['foto'])) : ?>
                            <img src="uploads/siswa/<?php echo $siswa['foto']; ?>" alt="Foto Siswa" class="img-thumbnail mt-2" width="150">
                        <?php endif; ?>
                    </div>
                </div>
                <div class="col-12 d-flex justify-content-end">
                    <button type="submit" class="btn btn-primary me-1 mb-1">Update</button>
                    <a href="siswa.php" class="btn btn-light-secondary me-1 mb-1">Batal</a>
                </div>
            </div>
        </div>
    </form>
</div>

<?php
include 'template/footer.php';
?>
