<?php
include 'template/koneksi.php';

// Query untuk mengambil data pengguna berdasarkan username
$sql = "SELECT * FROM tbl_user WHERE username = ?";
$stmt = $conn->prepare($sql);
$stmt->bind_param("s", $username);
$stmt->execute();
$result = $stmt->get_result();

$userData = $result->fetch_assoc();

// Tutup statement dan koneksi
$stmt->close();

include 'template/header.php';
include 'template/menu.php';

// Cek apakah terdapat status sukses setelah submit data siswa
if (isset($_GET['status']) && $_GET['status'] == 'success') {
    echo '<div class="alert alert-success alert-dismissible show fade">
                            Data siswa berhasil disimpan!!!
                            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                        </div>';
}

if (isset($_GET['status']) && $_GET['status'] == 'update_success') {
    echo '<div class="alert alert-warning alert-dismissible fade show" role="alert">
            Data siswa berhasil diperbarui!
            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
          </div>';
}

if (isset($_GET['status']) && $_GET['status'] == 'delete_success') {
    echo '<div class="alert alert-danger alert-dismissible fade show" role="alert">
            Data siswa berhasil dihapus!!!
            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
          </div>';
}

// Query untuk mengambil data siswa dari tbl_siswa
$sql_guru = "SELECT * FROM tbl_user WHERE role_id = 2";
$result_guru = $conn->query($sql_guru);
?>

<button type="button" class="btn btn-outline-primary block" data-bs-toggle="modal" data-bs-target="#default">
    Add Guru Piket
</button>

<!-- Tabel Data Siswa -->
<div class="table-responsive mt-3">
    <table class="table table-striped" id="siswaTable">
        <thead>
            <tr>
                <th>No</th>
                <th>Username</th>
                <th>Email</th>
                <th>Aksi</th>
            </tr>
        </thead>
        <tbody>
            <?php
            $nomor = 1;
            if ($result_guru->num_rows > 0) {
                while($row = $result_guru->fetch_assoc()) {
                    echo "<tr>";
                    echo "<td>" . $nomor++ . "</td>";
                    echo "<td>" . htmlspecialchars($row['username']) . "</td>";
                    echo "<td>" . htmlspecialchars($row['email']) . "</td>";
                    
                    echo "<td>
                            <a href='edit_guru.php?id=" . $row['id'] . "' class='btn btn-sm btn-warning'>Edit</a>
                            <a href='hapus_guru.php?id=" . $row['id'] . "' class='btn btn-sm btn-danger' onclick='return confirm(\"Apakah Anda yakin ingin menghapus data ini?\")'>Hapus</a>
                          </td>";
                    echo "</tr>";
                }
            } else {
                echo "<tr><td colspan='9' class='text-center'>Tidak ada data siswa</td></tr>";
            }
            ?>
        </tbody>
    </table>
</div>

<!--Basic Modal -->
<div class="modal fade text-left" id="default" tabindex="-1" role="dialog" aria-labelledby="myModalLabel1" aria-hidden="true">
    <div class="modal-dialog modal-dialog-scrollable" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="myModalLabel1">Add Siswa</h5>
                <button type="button" class="close rounded-pill" data-bs-dismiss="modal" aria-label="Close">
                    <i data-feather="x"></i>
                </button>
            </div>
            <div class="modal-body">
                <form class="form form-vertical" method="POST" action="proses_guru_piket.php">
                    <div class="form-body">
                        <div class="row">
                            <!-- Form input fields -->
                            <div class="form-group">
                                <label for="username">Username</label>
                                <input type="text" class="form-control" id="username" name="username" required>
                            </div>
                            <div class="form-group">
                                <label for="email">Email</label>
                                <input type="email" class="form-control" id="email" name="email" required>
                            </div>
                            <div class="form-group">
                                <label for="password">Password</label>
                                <input type="password" class="form-control" id="password" name="password" required>
                                <input type="hidden" class="form-control" id="role_id" name="role_id" value="2">
                            </div>
                            
                            <div class="col-12 d-flex justify-content-end">
                                <button type="submit" class="btn btn-primary me-1 mb-1">Submit</button>
                                <button type="reset" class="btn btn-light-secondary me-1 mb-1">Reset</button>
                            </div>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>

<?php
include 'template/footer.php';
?>
