<?php
include 'template/koneksi.php';

// Ambil ID siswa dari parameter URL
$id_siswa = isset($_GET['id']) ? intval($_GET['id']) : 0;

// Jika ID siswa tidak valid, redirect kembali ke halaman siswa.php
if ($id_siswa <= 0) {
    header("Location: siswa.php");
    exit();
}

// Query untuk menghapus data siswa berdasarkan ID
$sql = "DELETE FROM tbl_siswa WHERE id_siswa = ?";
$stmt = $conn->prepare($sql);
$stmt->bind_param("i", $id_siswa);

if ($stmt->execute()) {
    // Jika penghapusan berhasil, redirect kembali ke halaman siswa.php dengan pesan sukses
    header("Location: siswa.php?status=delete_success");
    exit();
} else {
    // Jika terjadi kesalahan, redirect kembali ke halaman siswa.php dengan pesan gagal
    header("Location: siswa.php?status=delete_error");
    exit();
}

// Tutup statement dan koneksi
$stmt->close();
$conn->close();
?>
