<?php
include 'template/koneksi.php';

// Cek status setelah operasi CRUD
if (isset($_GET['status']) && $_GET['status'] == 'success') {
    echo '<div class="alert alert-success alert-dismissible show fade">
            Data kelas berhasil disimpan!
            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
          </div>';
}
if (isset($_GET['status']) && $_GET['status'] == 'update_success') {
    echo '<div class="alert alert-warning alert-dismissible show fade">
            Data kelas berhasil diperbarui!
            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
          </div>';
}
if (isset($_GET['status']) && $_GET['status'] == 'delete_success') {
    echo '<div class="alert alert-danger alert-dismissible show fade">
            Data kelas berhasil dihapus!
            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
          </div>';
}

// Query untuk mendapatkan data kelas
$sql_kelas = "SELECT * FROM tbl_kelas ORDER BY kelas ASC";
$result_kelas = $conn->query($sql_kelas);

include 'template/header.php';
include 'template/menu.php';
?>

<button type="button" class="btn btn-outline-primary block" data-bs-toggle="modal" data-bs-target="#modalKelas">
    Tambah Kelas
</button>

<!-- Tabel Data Kelas -->
<div class="table-responsive mt-3">
    <table class="table table-striped" id="kelasTable">
        <thead>
            <tr>
                <th>No</th>
                <th>Kelas</th>
                <th>Nama Kelas</th>
                <th>Aksi</th>
            </tr>
        </thead>
        <tbody>
            <?php
            $nomor = 1;
            if ($result_kelas->num_rows > 0) {
                while ($row = $result_kelas->fetch_assoc()) {
                    echo "<tr>";
                    echo "<td>" . $nomor++ . "</td>";
                    echo "<td>" . htmlspecialchars($row['kelas']) . "</td>";
                    echo "<td>" . htmlspecialchars($row['nama_kelas']) . "</td>";
                    echo "<td>
                            <a href='edit_kelas.php?id_kelas=" . $row['id_kelas'] . "' class='btn btn-sm btn-warning'>Edit</a>
                            <a href='hapus_kelas.php?id_kelas=" . $row['id_kelas'] . "' class='btn btn-sm btn-danger' onclick='return confirm(\"Apakah Anda yakin ingin menghapus data ini?\")'>Hapus</a>
                          </td>";
                    echo "</tr>";
                }
            } else {
                echo "<tr><td colspan='4' class='text-center'>Tidak ada data kelas</td></tr>";
            }
            ?>
        </tbody>
    </table>
</div>

<!-- Modal Tambah Kelas -->
<div class="modal fade" id="modalKelas" tabindex="-1" aria-labelledby="modalKelasLabel" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="modalKelasLabel">Tambah Kelas</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                <form action="proses_kelas.php" method="POST">
                    <div class="mb-3">
                        <label for="kelas" class="form-label">Kelas</label>
                        <input type="number" class="form-control" id="kelas" name="kelas" required>
                    </div>
                    <div class="mb-3">
                        <label for="nama_kelas" class="form-label">Nama Kelas</label>
                        <input type="text" class="form-control" id="nama_kelas" name="nama_kelas" required>
                    </div>
                    <div class="d-flex justify-content-end">
                        <button type="submit" class="btn btn-primary">Simpan</button>
                        <button type="reset" class="btn btn-secondary ms-2">Reset</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>

<?php
include 'template/footer.php';
?>
