<?php
include 'template/koneksi.php';

// Query untuk mengambil data kelas
$query_kelas = "SELECT id_kelas, nama_kelas FROM tbl_kelas";
$result_kelas = $conn->query($query_kelas);

if (!$result_kelas) {
    die("Query error: " . $conn->error);
}

include 'template/header.php';
include 'template/menu.php';
?>

<div class="container mt-4">
    <h3 class="text-center">Data Absensi</h3>
    <form id="filterForm">
        <div class="row">
            <!-- Input Tanggal Mulai -->
            <div class="col-md-3">
                <div class="form-group">
                    <label for="start_date">Tanggal Mulai</label>
                    <input type="date" id="start_date" name="start_date" class="form-control" required>
                </div>
            </div>
            <!-- Input Tanggal Selesai -->
            <div class="col-md-3">
                <div class="form-group">
                    <label for="end_date">Tanggal Selesai</label>
                    <input type="date" id="end_date" name="end_date" class="form-control" required>
                </div>
            </div>
            <!-- Dropdown Kelas -->
            <div class="col-md-3">
                <div class="form-group">
                    <label for="kelas">Kelas</label>
                    <select name="kelas" id="kelas" class="form-select">
                        <option value="">Pilih Kelas</option>
                        <?php
                        while ($row_kelas = $result_kelas->fetch_assoc()) {
                            echo "<option value='" . htmlspecialchars($row_kelas['id_kelas']) . "'>" . htmlspecialchars($row_kelas['nama_kelas']) . "</option>";
                        }
                        ?>
                    </select>
                </div>
            </div>
            <!-- Dropdown Jenis -->
            <div class="col-md-3">
                <div class="form-group">
                    <label for="jenis">Jenis</label>
                    <select id="jenis" name="jenis" class="form-select">
                        <option value="">Semua</option>
                        <option value="Masuk">Masuk</option>
                        <option value="Pulang">Pulang</option>
                        <option value="Izin">Izin</option>
                    </select>
                </div>
            </div>
            <!-- Dropdown Status -->
            <div class="col-md-3">
                <div class="form-group">
                    <label for="status">Status</label>
                    <select id="status" name="status" class="form-select">
                        <option value="">Semua</option>
                        <option value="Hadir">Hadir</option>
                        <option value="Terlambat">Terlambat</option>
                        <option value="Bolos">Bolos</option>
                        <option value="Pulang">Pulang</option>
                        <option value="Izin">Izin</option>
                        <option value="Sakit">Sakit</option>
                        <option value="Tidak Masuk">Tidak Masuk</option>
                        <option value="Tidak Pulang">Tidak Pulang</option>
                    </select>
                </div>
            </div>
        </div>
        <div class="mt-3">
            <button type="button" id="filterButton" class="btn btn-primary">Tampilkan</button>
        </div>
    </form>

    <!-- Area untuk Menampilkan Data -->
    <div class="table-responsive mt-4" id="resultTable">
        <!-- Data akan dimuat di sini secara asinkron -->
    </div>

    <div class="mt-3 text-end mb-5">
        <button id="printButton" class="btn btn-secondary">
            <i class="fas fa-print"></i> Print
        </button>
        <button id="exportExcelButton" class="btn btn-success ms-2">
            <i class="fas fa-file-excel"></i> Export Excel
        </button>
    </div>
</div>

<script src="https://cdn.jsdelivr.net/npm/xlsx/dist/xlsx.full.min.js"></script>
<script>
    // Event Listener untuk Tombol Tampilkan
    document.getElementById('filterButton').addEventListener('click', function() {
        const start_date = document.getElementById('start_date').value;
        const end_date = document.getElementById('end_date').value;
        const kelas = document.getElementById('kelas').value;
        const jenis = document.getElementById('jenis').value;
        const status = document.getElementById('status').value;

        if (!start_date || !end_date) {
            alert('Tanggal mulai dan tanggal selesai harus diisi.');
            return;
        }

        const xhr = new XMLHttpRequest();
        xhr.open('POST', 'proses_absensi.php', true);
        xhr.setRequestHeader('Content-type', 'application/x-www-form-urlencoded');
        xhr.onload = function() {
            if (this.status === 200) {
                document.getElementById('resultTable').innerHTML = this.responseText;
            }
        };
        xhr.send(`start_date=${start_date}&end_date=${end_date}&kelas=${kelas}&jenis=${jenis}&status=${status}`);
    });

    // Event Listener untuk Tombol Export Excel
    document.getElementById('exportExcelButton').addEventListener('click', function () {
        const table = document.getElementById('resultTable');
        if (!table.innerHTML.trim()) {
            alert("Tidak ada data untuk diekspor!");
            return;
        }

        const wb = XLSX.utils.table_to_book(table, { sheet: "Absensi" });
        XLSX.writeFile(wb, `Absensi_${new Date().toISOString().slice(0, 10)}.xlsx`);
    });

    // Event Listener untuk Tombol Print
    document.getElementById('printButton').addEventListener('click', function() {
        const printContent = document.getElementById('resultTable').innerHTML;
        const originalContent = document.body.innerHTML;

        document.body.innerHTML = `
            <html>
            <head>
                <title>Cetak Data Absensi</title>
                <style>
                    table { width: 100%; border-collapse: collapse; margin: 20px 0; }
                    th, td { border: 1px solid #000; padding: 8px; text-align: left; }
                    th { background-color: #f2f2f2; }
                </style>
            </head>
            <body>
                <h3>Data Absensi</h3>
                ${printContent}
            </body>
            </html>
        `;

        window.print();
        document.body.innerHTML = originalContent;
        location.reload();
    });
</script>

<?php
include 'template/footer.php';
?>
