<?php
include 'template/koneksi.php';

// Proses simpan data pengaturan
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $nama_aplikasi = $_POST['nama_aplikasi'];
    $jam_masuk = $_POST['jam_masuk'];
    $jam_pulang = $_POST['jam_pulang'];

    // Cek apakah file logo diunggah
    $target_dir = "pengaturan/";
    if (!empty($_FILES["logo_aplikasi"]["name"])) {
        // Proses upload file baru
        $target_file = $target_dir . basename($_FILES["logo_aplikasi"]["name"]);
        if (move_uploaded_file($_FILES["logo_aplikasi"]["tmp_name"], $target_file)) {
            // Jika file berhasil diunggah, gunakan file baru
            $logo_aplikasi = $target_file;
        } else {
            // Jika upload gagal, tampilkan pesan error
            echo "Error: Logo gagal diunggah.";
            exit();
        }
    } else {
        // Jika tidak ada file yang diunggah, gunakan logo lama
        $sql_get_logo = "SELECT logo_aplikasi FROM tbl_pengaturan LIMIT 1";
        $result_logo = $conn->query($sql_get_logo);
        if ($result_logo->num_rows > 0) {
            $logo_aplikasi = $result_logo->fetch_assoc()['logo_aplikasi'];
        } else {
            $logo_aplikasi = ''; // Default jika data tidak ditemukan
        }
    }

    // Cek apakah data sudah ada
    $sql_check = "SELECT * FROM tbl_pengaturan LIMIT 1";
    $result = $conn->query($sql_check);

    if ($result->num_rows > 0) {
        // Update data jika ada
        $sql_update = "UPDATE tbl_pengaturan SET nama_aplikasi = ?, logo_aplikasi = ?, jam_masuk = ?, jam_pulang = ?";
        $stmt = $conn->prepare($sql_update);
        $stmt->bind_param("ssss", $nama_aplikasi, $logo_aplikasi, $jam_masuk, $jam_pulang);
    } else {
        // Insert data baru jika belum ada
        $sql_insert = "INSERT INTO tbl_pengaturan (nama_aplikasi, logo_aplikasi, jam_masuk, jam_pulang) VALUES (?, ?, ?, ?)";
        $stmt = $conn->prepare($sql_insert);
        $stmt->bind_param("ssss", $nama_aplikasi, $logo_aplikasi, $jam_masuk, $jam_pulang);
    }

    // Eksekusi dan periksa hasil
    if ($stmt->execute() && $stmt->affected_rows > 0) {
        header("Location: pengaturan.php?status=success");
        exit();
    } else {
        echo "Error: " . $stmt->error;
    }
}

// Ambil data pengaturan
$sql_get = "SELECT * FROM tbl_pengaturan LIMIT 1";
$result_get = $conn->query($sql_get);
$pengaturan = $result_get->fetch_assoc();

include 'template/header.php';
include 'template/menu.php';

// Notifikasi sukses
if (isset($_GET['status']) && $_GET['status'] == 'success') {
    echo '<div class="alert alert-success alert-dismissible show fade">
            Data pengaturan berhasil disimpan!
            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
          </div>';
}
?>

<!-- Form Pengaturan -->
<div class="container mt-3">
    <h2>Pengaturan Aplikasi</h2>
    <form method="POST" enctype="multipart/form-data">
        <div class="mb-3">
            <label for="nama_aplikasi" class="form-label">Nama Aplikasi</label>
            <input type="text" class="form-control" id="nama_aplikasi" name="nama_aplikasi" value="<?php echo htmlspecialchars($pengaturan['nama_aplikasi'] ?? ''); ?>" required>
        </div>
        <div class="mb-3">
            <label for="logo_aplikasi" class="form-label">Logo Aplikasi</label>
            <input type="file" class="form-control" id="logo_aplikasi" name="logo_aplikasi">
            <?php if (!empty($pengaturan['logo_aplikasi'])): ?>
                <img src="<?php echo htmlspecialchars($pengaturan['logo_aplikasi']); ?>" alt="Logo Aplikasi" style="max-width: 100px; margin-top: 10px;">
            <?php endif; ?>
        </div>
        <div class="mb-3">
            <label for="jam_masuk" class="form-label">Jam Masuk</label>
            <input type="time" class="form-control" id="jam_masuk" name="jam_masuk" value="<?php echo htmlspecialchars($pengaturan['jam_masuk'] ?? ''); ?>" required>
        </div>
        <div class="mb-3">
            <label for="jam_pulang" class="form-label">Jam Pulang</label>
            <input type="time" class="form-control" id="jam_pulang" name="jam_pulang" value="<?php echo htmlspecialchars($pengaturan['jam_pulang'] ?? ''); ?>" required>
        </div>
        <button type="submit" class="btn btn-primary">Simpan</button>
    </form>
</div>

<?php include 'template/footer.php'; ?>
