<?php
include 'template/koneksi.php';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $start_date = $_POST['start_date'] ?? null;
    $end_date   = $_POST['end_date'] ?? null;
    $jenis      = $_POST['jenis'] ?? '';
    $status     = $_POST['status'] ?? '';
    $kelas      = $_POST['kelas'] ?? '';

    if (!$start_date || !$end_date) {
        echo '<div class="alert alert-warning">Tanggal mulai dan selesai wajib diisi.</div>';
        exit;
    }

    // Ambil semua siswa (filter kelas jika dipilih)
    $sql_siswa = "
        SELECT s.id_siswa, s.rfid, s.nis, s.nama_siswa, k.nama_kelas
        FROM tbl_siswa s
        LEFT JOIN tbl_kelas k ON s.id_kelas = k.id_kelas
        WHERE 1=1
    ";

    if (!empty($kelas)) {
        $kelas_safe = $conn->real_escape_string($kelas);
        $sql_siswa .= " AND s.id_kelas = '$kelas_safe'";
    }

    $sql_siswa .= " ORDER BY k.nama_kelas, s.nama_siswa";
    $result_siswa = $conn->query($sql_siswa);

    if (!$result_siswa || $result_siswa->num_rows == 0) {
        echo '<div class="alert alert-info">Tidak ada data siswa ditemukan.</div>';
        exit;
    }

    echo '
    <table class="table table-bordered table-striped">
        <thead class="table-dark">
            <tr>
                <th>No</th>
                <th>Tanggal</th>
                <th>Nama Siswa</th>
                <th>NIS</th>
                <th>Kelas</th>
                <th>Jenis</th>
                <th>Status</th>
                <th>Keterangan</th>
            </tr>
        </thead>
        <tbody>
    ';

    $no = 1;

    // Loop setiap siswa
    while ($siswa = $result_siswa->fetch_assoc()) {
        $period = new DatePeriod(
            new DateTime($start_date),
            new DateInterval('P1D'),
            (new DateTime($end_date))->modify('+1 day')
        );

        foreach ($period as $dt) {
            $tgl = $dt->format('Y-m-d');

            // === Cek Absensi Masuk ===
            $sql_masuk = "
                SELECT jenis, status, keterangan
                FROM tbl_absensi
                WHERE rfid = '{$siswa['rfid']}'
                AND DATE(date_time) = '$tgl'
                AND jenis = 'Masuk'
                LIMIT 1
            ";
            $result_masuk = $conn->query($sql_masuk);

            if ($result_masuk && $result_masuk->num_rows > 0) {
                $masuk = $result_masuk->fetch_assoc();
                $jenis_ = 'Masuk';
                $status_ = $masuk['status'] ?: 'Hadir';
                $ket_ = $masuk['keterangan'] ?: '-';
            } else {
                $jenis_ = 'Masuk';
                $status_ = 'Tidak Masuk';
                $ket_ = '-';
            }

            // Filter berdasarkan jenis & status
            if ((!empty($jenis) && $jenis_ !== $jenis) || (!empty($status) && $status_ !== $status)) {
                // lanjut ke cek pulang
            } else {
                echo "<tr>
                        <td>{$no}</td>
                        <td>{$tgl}</td>
                        <td>" . htmlspecialchars($siswa['nama_siswa']) . "</td>
                        <td>" . htmlspecialchars($siswa['nis']) . "</td>
                        <td>" . htmlspecialchars($siswa['nama_kelas']) . "</td>
                        <td>{$jenis_}</td>
                        <td>{$status_}</td>
                        <td>{$ket_}</td>
                      </tr>";
                $no++;
            }

            // === Cek Absensi Pulang ===
            $sql_pulang = "
                SELECT jenis, status, keterangan
                FROM tbl_absensi
                WHERE rfid = '{$siswa['rfid']}'
                AND DATE(date_time) = '$tgl'
                AND jenis = 'Pulang'
                LIMIT 1
            ";
            $result_pulang = $conn->query($sql_pulang);

            if ($result_pulang && $result_pulang->num_rows > 0) {
                $pulang = $result_pulang->fetch_assoc();
                $jenis_ = 'Pulang';
                $status_ = $pulang['status'] ?: 'Hadir';
                $ket_ = $pulang['keterangan'] ?: '-';
            } else {
                $jenis_ = 'Pulang';
                $status_ = 'Tidak Pulang';
                $ket_ = 'Tidak Pulang';
            }

            // Filter berdasarkan jenis & status
            if ((!empty($jenis) && $jenis_ !== $jenis) || (!empty($status) && $status_ !== $status)) continue;

            echo "<tr>
                    <td>{$no}</td>
                    <td>{$tgl}</td>
                    <td>" . htmlspecialchars($siswa['nama_siswa']) . "</td>
                    <td>" . htmlspecialchars($siswa['nis']) . "</td>
                    <td>" . htmlspecialchars($siswa['nama_kelas']) . "</td>
                    <td>{$jenis_}</td>
                    <td>{$status_}</td>
                    <td>{$ket_}</td>
                  </tr>";
            $no++;
        }
    }

    echo '</tbody></table>';
}
?>
